<?php

namespace App\Http\Controllers;

use App\Link;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Helper;
use File;
use Image;
use Alert;
use Illuminate\Database\QueryException;
use Illuminate\Http\Response;
use Yajra\DataTables\Facades\DataTables;

class LinkController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        return view('pages.be.links');
    }

    function json()
    {
        set_time_limit(0);
        ini_set('memory_limit', '-1');
        $data = Link::orderBy('id', 'DESC')->get();
        return DataTables::of($data)
                    ->addIndexColumn()
                    ->editColumn('options', function($row){
                        $count = Link::count();
                        if($count <= 1)
                        {
                            $disabled = "disabled";
                        }else{
                            $disabled = "";
                        }

                        $edit = route('link.edit', $row->id);
                        $btn = "&emsp;<a href='{$edit}' class='btn btn-sm btn-warning modal-show edit' title='Form Edit Link: {$row->name}'><i class='fa fa-pencil'></i></a> <button type='button' class='btn btn-sm btn-danger' {$disabled} id='destroy' data-id='{$row->id}'><i class='fa fa-trash'></i></button>";
                        return $btn;
                    })
                    ->editColumn('status', function($row){
                        if($row->status == 1){
                            $status = "<label class='switch switch-primary'><input data-id='{$row->id}' type='checkbox' id='status' checked ><span></span></label>";
                        }else{
                            $status = "<label class='switch switch-primary'><input data-id='{$row->id}' type='checkbox' id='status' ><span></span></label>";
                        }
                        return $status;
                    })
                    ->editColumn('created_at', function($row){
                        return $row->created_at != NULL ? \Helper::tgl_indo($row->created_at) : "-";
                    })
                    ->editColumn('updated_at', function($row){
                        return $row->updated_at != NULL ? \Helper::tgl_indo($row->updated_at) : "-";
                    })
                    ->rawColumns(['options', 'status'])
                    ->toJson();
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $model = new Link();
        return view('pages.be.form_link', compact('model'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $this->validate($request, [
                'name' => 'required|string',
                'link' => 'required'
            ],[
                'name.required' => 'Title Konten harus diisi!',
                'name.string' => 'Title Konten hanya string!',
                'link.required' => 'Deskripsi harus diisi!'
            ]);

            $data = new Link();
            $data->name = $request->name;
            $data->link = $request->link;
            $data->created_at = Carbon::now('Asia/Jakarta');
            $data->updated_at = null;
            $data->save();
            \Helper::log(\Auth::user()->username, "Menambah data link : ".$data->name);
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil menambah link!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Link  $link
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $model = Link::findOrFail($id);
        return view('pages.be.form_link', compact('model'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Link  $link
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            $this->validate($request, [
                'name' => 'required|string',
                'link' => 'required'
            ],[
                'name.required' => 'Title Konten harus diisi!',
                'name.string' => 'Title Konten hanya string!',
                'link.required' => 'Deskripsi harus diisi!'
            ]);
            $link = Link::findOrFail($id);
            $data = array(
                'name' => $request->name,
                'link' => $request->link,
                'updated_at' => Carbon::now('Asia/Jakarta')
            );
            $link->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate data link : ".$link->name);
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengupdate link!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }

    public function update_status(Request $request){
        try {
            $id = $request->id;
            $link = Link::findOrFail($id);
            if($link->status == 0){
                $data = array('status' => '1', 'updated_at' => Carbon::now('Asia/Jakarta'));
            }else{
                $data = array('status' => '0', 'updated_at' => Carbon::now('Asia/Jakarta'));
            }
            $link->update($data);
            \Helper::log(\Auth::user()->username, "Mengupdate status data link : ".$link->name);
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil mengupdate status link!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Link  $link
     * @return \Illuminate\Http\Response
     */

    public function remove(Request $request)
    {
        try {
            $id = $request->input('id');
            $link = Link::findOrFail($id);
            $link->delete();
            \Helper::log(\Auth::user()->username, "Menghapus data link : ".$link->name);
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil menghapus link!']);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => $e->errorInfo]);
        }
    }
}
