@extends('layouts.master')
@section('title', 'Buku Tamu')
@section('content')

<!-- Breadcrumb section -->
<div class="site-breadcrumb">
	<div class="container">
		<a href="#"><i class="fa fa-home"></i> Home</a> <i class="fa fa-angle-right"></i>
		<span>Buku Tamu</span>
	</div>
</div>
<!-- Breadcrumb section end -->


<!-- Courses section -->
<section class="event-section spad">
	<div class="container">
		<div class="row">
            <div class="col-md-4 col-sm-12">
                <h4>Form Isi Buku Tamu Sekolah :</h4>
                <hr>
                <form action="{{ route('fe.bukutamu.store') }}" method="POST" enctype="multipart/form-data" id="formSubmit">
                    @csrf
                    <div class="form-group">
                        <label>Nama <span>*</span></label>
                        <input type="text" class="form-control" id="nama" name="nama" placeholder="Ketikan nama anda...">
                    </div>
                    <div class="form-group">
                        <label>E-Mail</label>
                        <input type="email" class="form-control" id="email" name="email" placeholder="Ketikan email anda...">
                    </div>
                    <div class="form-group">
                        <label>No. Whatsapp/HP</label>
                        <input type="number" class="form-control" id="no_hp" name="no_hp" placeholder="Ketikan nomor hp anda...">
                    </div>
                    <div class="form-group">
                        <label>Alamat</label>
                        <textarea class="form-control" id="alamat" name="alamat"></textarea>
                    </div>
                    <div class="form-group">
                        <label>Tujuan Bertemu <span>*</span></label>
                        <select class="form-control" id="tujuan_id" name="tujuan_id">
                            <option value="">Pilih</option>
                            @php json_encode($tujuans) @endphp
                            @foreach($tujuans as $row)
                            <option value="{{ $row->id }}">{{ $row->nama }}{{ $row->jabatan != NULL ? ' - '.$row->jabatan : '' }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Keperluan <span>*</span></label>
                        <textarea class="form-control" id="keperluan" name="keperluan"></textarea>
                    </div>
                    <div class="form-group">
                        <button class="btn btn-lg btn-success btn-block" id="modal-btn-save">Kirim</button>
                    </div>
                </form>
            </div>
            <div class="col-md-8 col-sm-12 table-responsive">
                <h2>Daftar Buku Tamu Hari Ini : </h2>
                <hr>
                <table id="datatables" class="table table-striped table-bordered table-hover">
                    <thead>
                        <tr>
                            <th>No.</th>
                            <th>Nama</th>
                            <th>Tujuan</th>
                            <th>Tgl. Kunjungan</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            </div>
        </div>
	</div>
</section>
<!-- Courses section end-->

@endsection

@push('style')
<!-- DataTables -->
<link rel="stylesheet" type="text/css" href="{{url('assets/backend/DataTables')}}/css/jquery.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="{{url('assets/backend/DataTables')}}/css/rowReorder.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="{{url('assets/backend/DataTables')}}/css/responsive.dataTables.min.css">
@endpush

@push('scripts')
<!-- DataTables -->
<!-- <script src="{{url('assets/DataTables')}}/js/jquery-3.3.1.js"></script> -->
<script src="{{url('assets/backend/DataTables')}}/js/jquery.dataTables.min.js"></script>
<script src="{{url('assets/backend/DataTables')}}/js/dataTables.rowReorder.min.js"></script>
<script src="{{url('assets/backend/DataTables')}}/js/dataTables.responsive.min.js"></script>
<script>
/*This makes the timeout variable global so all functions can access it.*/
var timeout;

/*This is an example function and can be disreguarded
This function sets the loading div to a given string.*/
function loaded() {
    $('.loader').fadeOut("slow");
}
$(document).ready(function(){
	var dataTable = $('#datatables').DataTable({
      "stateSave": true,
      "processing" : true,
      "serverSide" : true,
      "searching" : true,
      "ajax" : {
       "url": "{{ route('fe.bukutamu.json') }}",
       "dataType": "json",
       "type": "GET",
      },
      "columns": [
        { data: 'DT_RowIndex', name: 'DT_RowIndex' },
        { "data": "nama" },
        { "data": "tujuan_id" },
        { "data": "created_at" },
      ],
    });

    $('body').on('click', '#modal-btn-save', function(e){
        e.preventDefault();
        $('.loader').fadeIn();
        clearTimeout(timeout);

        var form = $('#formSubmit'),
            url = form.attr('action'),
            method = $('input[name=_method]').val() == undefined ? 'POST' : 'PUT';

        form.find('.help-block').remove();
        form.find('.form-group').removeClass('has-error');
        $.ajax({
        url: url,
        method: method,
        dataType: "JSON",
        data: form.serialize(),
        success: function(response){
            timeout = setTimeout(loaded, 1000);
            if(response.code === 200){
                form.trigger('reset');
                $('#datatables').DataTable().ajax.reload();

                swal({
                    type: 'success',
                    icon: 'success',
                    title: 'Berhasil!',
                    text: response.msg
                })
            }else{
                swal({
                    type: 'error',
                    icon: 'error',
                    title: 'Gagal!',
                    text: response.msg
                })
            }
        },
        error: function(xhr){
            timeout = setTimeout(loaded, 1000);
            var res = xhr.responseJSON;
            if($.isEmptyObject(res) == false) {
            $.each(res.errors, function (key, value) {
                $('#' + key)
                    .closest('.form-group')
                    .addClass('has-error')
                    .append('<span class="help-block"><strong>' + value + '</strong></span>');
            });
            }
        }
        });
    });
});
</script>
@endpush
