@extends('layouts.master')
@section('title', 'Data Guru')
@section('content')

<!-- Breadcrumb section -->
<div class="site-breadcrumb">
	<div class="container">
		<a href="#"><i class="fa fa-home"></i> Home</a> <i class="fa fa-angle-right"></i>
		<span>Data Guru</span>
	</div>
</div>
<!-- Breadcrumb section end -->


<!-- About section -->
<section class="about-section spad pt-0">
	<div class="container">
		<div class="section-title text-center">
			<h3>Data Guru</h3>
			<p>Table Data Tenaga Pendidik</p>
		</div>
		<div class="row" style="font-size:14px;">
			<div class="col-lg-12">
				<h4>Guru</h4>
				<hr>
				<ul class="nav nav-tabs">
					<li class="active"><a href="#gurustatus" data-toggle="tab">Status</a></li>
		            <li><a href="#gurugolongan" data-toggle="tab">Golongan</a></li>
		            <li><a href="#gurusertifikasi" data-toggle="tab">Sertifikasi</a></li>
		            <li><a href="#guruijazah" data-toggle="tab">Ijazah</a></li>
		            <li><a href="#guruumur" data-toggle="tab">Umur</a></li>
		            <li><a href="#gurujeniskelamin" data-toggle="tab">Jenis Kelamin</a></li>
		            <li><a href="#gurudaftar" data-toggle="tab">Daftar</a></li>
				</ul>

				<div class="tab-content">
					<div id="gurustatus" class="tab-pane fade in active">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<th>Status</th>
									<th>Jumlah</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td>PNS</td>
									<td><?php echo $data_guru_status_pns->count(); ?></td>
								</tr>
								<tr>
									<td>GTT/GTY</td>
									<td><?php echo $data_guru_status_gtt->count(); ?></td>
								</tr>
								<tr>
									<td><b>Total</b></td>
									<td><?php echo $total = $data_guru_status_pns->count() + $data_guru_status_gtt->count(); ?></td>
								</tr>
							</tbody>
						</table>
					</div>
					<div id="gurugolongan" class="tab-pane fade">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<td>I</td>
									<td>II</td>
									<td>III</td>
									<td>IV</td>
									<th>Jumlah</th>
								</tr>
							</thead>
							<tbody>
								<tr>
                                    <td>{{$data_guru_gol_1->count()}}</td>
                                    <td>{{$data_guru_gol_2->count()}}</td>
                                    <td>{{$data_guru_gol_3->count()}}</td>
                                    <td>{{$data_guru_gol_4->count()}}</td>
                                    <td><?php echo $data_guru_gol_1->count()+$data_guru_gol_2->count()+$data_guru_gol_3->count()+$data_guru_gol_4->count(); ?></td>
                                </tr>
							</tbody>
						</table>
					</div>
					<div id="gurusertifikasi" class="tab-pane fade">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<th>Status</th>
									<th>Jumlah</th>
								</tr>
							</thead>
							<tbody>
								<tr>
                                    <td>Tersertifikasi</td>
                                    <td>{{ $data_guru_sertifikasi->count() }}</td>
                                </tr>
                                <tr>
                                    <td>Tidak Sertifikasi</td>
                                    <td>{{ $data_guru_non_sertifikasi->count() }}</td>
                                </tr>
                                <tr>
                                    <td><b>Total</b></td>
                                    <td>{{ $data_guru_sertifikasi->count()+$data_guru_non_sertifikasi->count() }}</td>
                                </tr>
							</tbody>
						</table>
					</div>
					<div id="guruijazah" class="tab-pane fade">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<th>Ijazah</th>
									<th>Jumlah</th>
								</tr>
							</thead>
							<tbody>
								<tr>
                                    <td>Kurang dari S1</td>
                                    <td>{{ $data_guru_ijazah_non_s1->count() }}</td>
                                </tr>
                                <tr>
                                    <td>S1 atau Lebih</td>
                                    <td>{{ $data_guru_ijazah_s1->count() }}</td>
                                </tr>
                                <tr>
                                    <td>Data Kosong</td>
                                    <td>{{ $data_guru_ijazah_non_data->count() }}</td>
                                </tr>
                                <tr>
                                    <td><b>Total</b></td>
                                    <td><?php echo $data_guru_ijazah_s1->count()+$data_guru_ijazah_non_s1->count()+$data_guru_ijazah_non_data->count() ?></td>
                                </tr>
							</tbody>
						</table>
					</div>
					<div id="guruumur" class="tab-pane fade">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<th>Umur</th>
									<th>Jumlah</th>
								</tr>
							</thead>
							<tbody>
								<tr>
                                    <td>Kurang dari 30 Tahun</td>
                                    <td>{{ $data_guru_kurang_30->count() }}</td>
                                </tr>
                                <tr>
                                    <td>31 - 35 Tahun</td>
                                    <td>{{ $data_guru_31_35->count() }}</td>
                                </tr>
                                <tr>
                                    <td>36 - 40 Tahun</td>
                                    <td>{{ $data_guru_36_40->count() }}</td>
                                </tr>
                                <tr>
                                    <td>41 - 45 Tahun</td>
                                    <td>{{ $data_guru_41_45->count() }}</td>
                                </tr>
                                <tr>
                                    <td>46 - 50 Tahun</td>
                                    <td>{{ $data_guru_46_50->count() }}</td>
                                </tr>
                                <tr>
                                    <td>51 - 55 Tahun</td>
                                    <td>{{ $data_guru_51_55->count() }}</td>
                                </tr>
                                <tr>
                                    <td>Lebih dari 55 Tahun</td>
                                    <td>{{ $data_guru_lebih_55->count() }}</td>
                                </tr>
                                <tr>
                                    <td><b>Total</b></td>
                                    <td><?php echo $data_guru_kurang_30->count()+$data_guru_31_35->count()+$data_guru_36_40->count()+$data_guru_41_45->count()+$data_guru_46_50->count()+$data_guru_51_55->count()+$data_guru_lebih_55->count(); ?></td>
                                </tr>
							</tbody>
						</table>
					</div>
					<div id="gurujeniskelamin" class="tab-pane fade">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<th>Jenis Kelamin</th>
									<th>Jumlah</th>
								</tr>
							</thead>
							<tbody>
								<tr>
                                    <td>Laki-laki</td>
                                    <td>{{ $data_guru_laki->count() }}</td>
                                </tr>
                                <tr>
                                    <td>Perempuan</td>
                                    <td>{{ $data_guru_perempuan->count() }}</td>
                                </tr>
                                <tr>
                                    <td><b>Total</b></td>
                                    <td><?php echo $data_guru_laki->count() + $data_guru_perempuan->count(); ?></td>
                                </tr>
							</tbody>
						</table>
					</div>
					<div id="gurudaftar" class="tab-pane fade">
						<table id="datatable1" class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<th>NUPTK</th>
									<th>Nama</th>
									<th>Jenis Kelamin</th>
									<th>Jabatan</th>
								</tr>
							</thead>
							<tbody>
								@foreach($daftar_guru as $row)
								<tr>
									<td><?php echo substr($row->nuptk_ptk, 0, 14).'XXX'; ?></td>
									<td>{{ $row->nama_ptk }}</td>
									<td>{{ $row->jk_ptk }}</td>
									<td>{{ $row->jenis_ptk }}</td>
								</tr>
								@endforeach
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
		<hr>
		<div class="row" style="font-size:14px;">
			<div class="col-lg-12">
				<h4>Tenaga Kependidikan</h4>
				<hr>
				<ul class="nav nav-tabs">
					<li class="active"><a data-toggle="tab" href="#ptkstatus">Status</a></li>
					<li><a data-toggle="tab" href="#ptkgolongan">Golongan</a></li>
					<li><a data-toggle="tab" href="#ptksertifikasi">Sertifikasi</a></li>
					<li><a data-toggle="tab" href="#ptkijazah">Ijazah</a></li>
					<li><a data-toggle="tab" href="#ptkumur">Umur</a></li>
					<li><a data-toggle="tab" href="#ptkjeniskelamin">Jenis Kelamin</a></li>
					<li><a data-toggle="tab" href="#ptkdaftar">Daftar</a></li>
				</ul>

				<div class="tab-content">
					<div id="ptkstatus" class="tab-pane fade in active">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<th>Status</th>
									<th>Jumlah</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<td>PNS</td>
									<td><?php echo $data_ptk_status_pns->count(); ?></td>
								</tr>
								<tr>
									<td>PTT/PTY</td>
									<td><?php echo $data_ptk_status_ptt->count(); ?></td>
								</tr>
								<tr>
									<td><b>Total</b></td>
									<td><?php echo $total = $data_ptk_status_pns->count() + $data_ptk_status_ptt->count(); ?></td>
								</tr>
							</tbody>
						</table>
					</div>
					<div id="ptkgolongan" class="tab-pane fade">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<td>I</td>
									<td>II</td>
									<td>III</td>
									<td>IV</td>
									<th>Jumlah</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<tr>
										<td>{{$data_ptk_gol_1->count()}}</td>
										<td>{{$data_ptk_gol_2->count()}}</td>
										<td>{{$data_ptk_gol_3->count()}}</td>
										<td>{{$data_ptk_gol_4->count()}}</td>
										<td><?php echo $data_ptk_gol_1->count()+$data_ptk_gol_2->count()+$data_ptk_gol_3->count()+$data_ptk_gol_4->count(); ?></td>
									</tr>
								</tr>
							</tbody>
						</table>
					</div>
					<div id="ptksertifikasi" class="tab-pane fade">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<th>Status</th>
									<th>Jumlah</th>
								</tr>
							</thead>
							<tbody>
								<tr>
									<tr>
										<td>Tersertifikasi</td>
										<td>{{ $data_ptk_sertifikasi->count() }}</td>
									</tr>
									<tr>
										<td>Tidak Sertifikasi</td>
										<td>{{ $data_ptk_non_sertifikasi->count() }}</td>
									</tr>
								</tr>
							</tbody>
						</table>
					</div>
					<div id="ptkijazah" class="tab-pane fade">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<th>Ijazah</th>
									<th>Jumlah</th>
								</tr>
							</thead>
							<tbody>
								<tr>
                                    <td>Kurang dari S1</td>
                                    <td>{{ $data_ptk_ijazah_non_s1->count() }}</td>
                                </tr>
                                <tr>
                                    <td>S1 atau Lebih</td>
                                    <td>{{ $data_ptk_ijazah_s1->count() }}</td>
                                </tr>
                                <tr>
                                    <td>Data Kosong</td>
                                    <td>{{ $data_ptk_ijazah_non_data->count() }}</td>
                                </tr>
                                <tr>
                                    <td><b>Total</b></td>
                                    <td><?php echo $data_ptk_ijazah_s1->count()+$data_ptk_ijazah_non_s1->count()+$data_ptk_ijazah_non_data->count() ?></td>
                                </tr>
							</tbody>
						</table>
					</div>
					<div id="ptkumur" class="tab-pane fade">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<th>Umur</th>
									<th>Jumlah</th>
								</tr>
							</thead>
							<tbody>
								<tr>
                                    <td>Kurang dari 30 Tahun</td>
                                    <td>{{ $data_ptk_kurang_30->count() }}</td>
                                </tr>
                                <tr>
                                    <td>31 - 35 Tahun</td>
                                    <td>{{ $data_ptk_31_35->count() }}</td>
                                </tr>
                                <tr>
                                    <td>36 - 40 Tahun</td>
                                    <td>{{ $data_ptk_36_40->count() }}</td>
                                </tr>
                                <tr>
                                    <td>41 - 45 Tahun</td>
                                    <td>{{ $data_ptk_41_45->count() }}</td>
                                </tr>
                                <tr>
                                    <td>46 - 50 Tahun</td>
                                    <td>{{ $data_ptk_46_50->count() }}</td>
                                </tr>
                                <tr>
                                    <td>51 - 55 Tahun</td>
                                    <td>{{ $data_ptk_51_55->count() }}</td>
                                </tr>
                                <tr>
                                    <td>Lebih dari 55 Tahun</td>
                                    <td>{{ $data_ptk_lebih_55->count() }}</td>
                                </tr>
                                <tr>
                                    <td><b>Total</b></td>
                                    <td><?php echo $data_ptk_kurang_30->count()+$data_ptk_31_35->count()+$data_ptk_36_40->count()+$data_ptk_41_45->count()+$data_ptk_46_50->count()+$data_ptk_51_55->count()+$data_ptk_lebih_55->count(); ?></td>
                                </tr>
							</tbody>
						</table>
					</div>
					<div id="ptkjeniskelamin" class="tab-pane fade">
						<table class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<th>Jenis Kelamin</th>
									<th>Jumlah</th>
								</tr>
							</thead>
							<tbody>
								<tr>
                                    <td>Laki-laki</td>
                                    <td>{{ $data_ptk_laki->count() }}</td>
                                </tr>
                                <tr>
                                    <td>Perempuan</td>
                                    <td>{{ $data_ptk_perempuan->count() }}</td>
                                </tr>
                                <tr>
                                    <td><b>Total</b></td>
                                    <td><?php echo $data_ptk_laki->count() + $data_ptk_perempuan->count(); ?></td>
                                </tr>
							</tbody>
						</table>
					</div>
					<div id="ptkdaftar" class="tab-pane fade">
						<table id="datatable2" class="table table-striped table-bordered table-hover">
							<thead>
								<tr>
									<th>NUPTK</th>
									<th>Nama</th>
									<th>Jenis Kelamin</th>
									<th>Jabatan</th>
								</tr>
							</thead>
							<tbody>
								@foreach($daftar_ptk as $row)
								<tr>
									<td><?php echo substr($row->nuptk_ptk, 0, 14).'XXX'; ?></td>
									<td>{{ $row->nama_ptk }}</td>
									<td>{{ $row->jk_ptk }}</td>
									<td>{{ $row->jenis_ptk }}</td>
								</tr>
								@endforeach
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<!-- About section end-->

@endsection

@push('style')
<!-- DataTables -->
<link rel="stylesheet" type="text/css" href="{{url('assets/backend/DataTables')}}/css/jquery.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="{{url('assets/backend/DataTables')}}/css/rowReorder.dataTables.min.css">
<link rel="stylesheet" type="text/css" href="{{url('assets/backend/DataTables')}}/css/responsive.dataTables.min.css">
@endpush

@push('scripts')
<!-- DataTables -->
<script src="{{url('assets/backend/DataTables')}}/js/jquery.dataTables.min.js"></script>
<script src="{{url('assets/backend/DataTables')}}/js/dataTables.rowReorder.min.js"></script>
<script src="{{url('assets/backend/DataTables')}}/js/dataTables.responsive.min.js"></script>
<script type="text/javascript">
	$('#datatable1').DataTable({
      "stateSave": true,
      "searching" : true,
    });
    $('#datatable2').DataTable({
      "stateSave": true,
      "searching" : true,
    });
</script>
@endpush
