<?php

namespace App\Http\Controllers;

use App\BukuTamu;
use Illuminate\Database\QueryException;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Yajra\DataTables\Facades\DataTables;

class BukuTamuController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('pages.be.bukutamu.index');
    }

    function json()
    {
        set_time_limit(0);
        ini_set('memory_limit', '-1');
        $data = BukuTamu::orderBy('id', 'DESC')->get();
        return DataTables::of($data)
                ->addIndexColumn()
                ->editColumn('options', function($row){
                    $btn = '';
                    $btn .= '<a class="btn btn-sm btn-info btn-show" href="'.route('bukutamu.show', $row->id).'" title="Detail Data Buku Tamu"><i class="fa fa-search"></i> Lihat</a> ';
                    $btn .= '<button class="btn btn-sm btn-danger destroy" url="'.route('bukutamu.destroy', $row->id).'"><i class="fa fa-trash"></i> Hapus</button> ';
                    return $btn;
                })
                ->editColumn('tujuan_id', function($row){
                    return $row->tujuan->nama.' - '.$row->tujuan->jabatan;
                })
                ->editColumn('created_at', function($row){
                    return \Helper::full_indo($row->created_at);
                })
                ->editColumn('updated_at', function($row){
                    if($row->updated_at != NULL){
                        return \Helper::full_indo($row->updated_at);
                    }else{
                        return '-';
                    }
                })
                ->rawColumns(['options'])
                ->make(true);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $bukutamu = BukuTamu::findOrFail($id);
        return view('pages.be.bukutamu.show', compact('bukutamu'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $bukutamu = BukuTamu::findOrFail($id);
            $bukutamu->delete();
            \Helper::log(\Auth::user()->username, "Menghapus data buku tamu : ".$bukutamu->nama);
            return response()->json(['code' => Response::HTTP_OK, 'msg' => 'Berhasil menghapus data buku tamu!'], Response::HTTP_OK);
        } catch (QueryException $e) {
            return response()->json(['code' => Response::HTTP_UNPROCESSABLE_ENTITY, 'msg' => 'Gagal menghapus data buku tamu : '.$e->errorInfo[2]], Response::HTTP_UNPROCESSABLE_ENTITY);
        }
    }
}
