<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

Route::group(['namespace' => 'Api\v1'], function () {
    //Login
    Route::post('v1/users/login', 'UserController@login')->name('users.login');
    Route::post('v1/users/cleartoken', 'UserController@cleartoken')->name('users.cleartoken');
    Route::put('v1/users/deviceToken/{username}', 'UserController@update_device_token')->name('users.deviceToken');
    Route::put('v1/users/updatePassword/{username}', 'UserController@update_password')->name('users.update_password');

    //Get List Domain
    Route::get('v1/get-domain', 'DataHostingController@getDomain')->name('getDomain');

    //Banner Sekolah
    Route::get('v1/banner', 'ServicesController@banners')->name('banners.index');
    Route::get('v1/banner/{id}', 'ServicesController@bannersShow')->name('banners.show');
    Route::post('v1/banner', 'ServicesController@bannersAdd')->name('banners.add');
    Route::post('v1/banner/{id}', 'ServicesController@bannersUpdate')->name('banners.update');
    Route::delete('v1/banner/{id}', 'ServicesController@bannerDestroy')->name('banners.destroy');
    Route::get('v1/banner/status/{id}', 'ServicesController@bannerStatus')->name('banners.status');

    //Struktur Sekolah
    Route::get('v1/struktur', 'ServicesController@strukturs')->name('strukturs.index');
    Route::post('v1/struktur/{id}', 'ServicesController@struktursUpdate')->name('strukturs.update');
    Route::get('v1/struktur/status/{id}', 'ServicesController@struktursStatus')->name('strukturs.status');

    //Management Sekolah
    Route::get('v1/sekolah', 'ServicesController@sekolah')->name('sekolah.index');
    Route::get('v1/sekolah/{id}', 'ServicesController@sekolahShow')->name('sekolah.show');
    Route::post('v1/sekolah', 'ServicesController@sekolahAdd')->name('sekolah.add');
    Route::post('v1/sekolah/{id}', 'ServicesController@sekolahUpdate')->name('sekolah.update');
    Route::delete('v1/sekolah/{id}', 'ServicesController@sekolahDestroy')->name('sekolah.destroy');
    Route::get('v1/sekolah/status/{id}', 'ServicesController@sekolahStatus')->name('sekolah.status');

    //Running text
    Route::get('v1/running', 'ServicesController@running')->name('running.index');
    Route::get('v1/running/{id}', 'ServicesController@runningShow')->name('running.show');
    Route::post('v1/running', 'ServicesController@runningAdd')->name('running.add');
    Route::post('v1/running/{id}', 'ServicesController@runningUpdate')->name('running.update');
    Route::delete('v1/running/{id}', 'ServicesController@runningDestroy')->name('running.destroy');
    Route::get('v1/running/status/{id}', 'ServicesController@runningStatus')->name('running.status');

    //Blog
    Route::get('v1/blog', 'ServicesController@blog')->name('blog.index');
    Route::get('v1/blog/{id}', 'ServicesController@blogShow')->name('blog.show');
    Route::post('v1/blog', 'ServicesController@blogAdd')->name('blog.add');
    Route::post('v1/blog/{id}', 'ServicesController@blogUpdate')->name('blog.update');
    Route::delete('v1/blog/{id}', 'ServicesController@blogDestroy')->name('blog.destroy');
    Route::get('v1/blog/status/{id}', 'ServicesController@blogStatus')->name('blog.status');

    //Page
    Route::get('v1/page', 'ServicesController@page')->name('page.index');
    Route::get('v1/page/{id}', 'ServicesController@pageShow')->name('page.show');
    Route::post('v1/page', 'ServicesController@pageAdd')->name('page.add');
    Route::post('v1/page/{id}', 'ServicesController@pageUpdate')->name('page.update');
    Route::delete('v1/page/{id}', 'ServicesController@pageDestroy')->name('page.destroy');
    Route::get('v1/page/status/{id}', 'ServicesController@pageStatus')->name('page.status');

    //Link
    Route::get('v1/link', 'ServicesController@link')->name('link.index');
    Route::get('v1/link/{id}', 'ServicesController@linkShow')->name('link.show');
    Route::post('v1/link', 'ServicesController@linkAdd')->name('link.add');
    Route::post('v1/link/{id}', 'ServicesController@linkUpdate')->name('link.update');
    Route::delete('v1/link/{id}', 'ServicesController@linkDestroy')->name('link.destroy');
    Route::get('v1/link/status/{id}', 'ServicesController@linkStatus')->name('link.status');

    //Kegiatan
    Route::get('v1/kegiatan', 'ServicesController@kegiatan')->name('kegiatan.index');
    Route::get('v1/kegiatan/{id}', 'ServicesController@kegiatanShow')->name('kegiatan.show');
    Route::post('v1/kegiatan', 'ServicesController@kegiatanAdd')->name('kegiatan.add');
    Route::post('v1/kegiatan/{id}', 'ServicesController@kegiatanUpdate')->name('kegiatan.update');
    Route::delete('v1/kegiatan/{id}', 'ServicesController@kegiatanDestroy')->name('kegiatan.destroy');
    Route::get('v1/kegiatan/status/{id}', 'ServicesController@kegiatanStatus')->name('kegiatan.status');

    //File
    Route::get('v1/file', 'ServicesController@file')->name('file.index');
    Route::get('v1/file/{id}', 'ServicesController@fileShow')->name('file.show');
    Route::post('v1/file', 'ServicesController@fileAdd')->name('file.add');
    Route::post('v1/file/{id}', 'ServicesController@fileUpdate')->name('file.update');
    Route::delete('v1/file/{id}', 'ServicesController@fileDestroy')->name('file.destroy');
    Route::get('v1/file/status/{id}', 'ServicesController@fileStatus')->name('file.status');

    //Gallery
    Route::get('v1/gallery', 'ServicesController@gallery')->name('gallery.index');
    Route::get('v1/gallery/{id}', 'ServicesController@galleryShow')->name('gallery.show');
    Route::post('v1/gallery', 'ServicesController@galleryAdd')->name('gallery.add');
    Route::post('v1/gallery/{id}', 'ServicesController@galleryUpdate')->name('gallery.update');
    Route::delete('v1/gallery/{id}', 'ServicesController@galleryDestroy')->name('gallery.destroy');
    Route::get('v1/gallery/status/{id}', 'ServicesController@galleryStatus')->name('gallery.status');

    //Profile User
    Route::get('v1/profile', 'ServicesController@profileUser')->name('profile.index');
    Route::get('v1/profile/{id}', 'ServicesController@profileUserShow')->name('profile.show');
    Route::post('v1/profile/{id}', 'ServicesController@profileUserUpdate')->name('profile.update');

    //Profile Sekolah
    Route::get('v1/profile-sekolah', 'ServicesController@profileSekolah')->name('profileSekolah.index');
    Route::post('v1/profile-sekolah/name/update/{id}', 'ServicesController@profileSekolahUpdateName')->name('profileSekolah.updateName');
    Route::post('v1/profile-sekolah/desc/update/{id}', 'ServicesController@profileSekolahUpdateDesc')->name('profileSekolah.updateDesc');
    Route::post('v1/profile-sekolah/logo/update/{id}', 'ServicesController@profileSekolahUpdateLogo')->name('profileSekolah.updateLogo');
    Route::post('v1/profile-sekolah/facebook/update/{id}', 'ServicesController@profileSekolahUpdateFB')->name('profileSekolah.updateFB');
    Route::post('v1/profile-sekolah/twitter/update/{id}', 'ServicesController@profileSekolahUpdateTwitter')->name('profileSekolah.updateTwitter');
    Route::post('v1/profile-sekolah/instagram/update/{id}', 'ServicesController@profileSekolahUpdateIG')->name('profileSekolah.updateIG');
    Route::post('v1/profile-sekolah/tautan1/update/{id}', 'ServicesController@profileSekolahUpdateTautan1')->name('profileSekolah.updateTautan1');
    Route::post('v1/profile-sekolah/tautan2/update/{id}', 'ServicesController@profileSekolahUpdateTautan2')->name('profileSekolah.updateTautan2');
    Route::post('v1/profile-sekolah/tautan3/update/{id}', 'ServicesController@profileSekolahUpdateTautan3')->name('profileSekolah.updateTautan3');

    //Navigasi
    Route::get('v1/navigasi', 'ServicesController@navigasi')->name('navigasi.index');
    Route::get('v1/navigasi/isParent', 'ServicesController@isParentNav')->name('navigasi.isParentNav');
    Route::get('v1/navigasi/{id}', 'ServicesController@navigasiShow')->name('navigasi.show');
    Route::post('v1/navigasi', 'ServicesController@navigasiStore')->name('navigasi.store');
    Route::post('v1/navigasi/{id}', 'ServicesController@navigasiUpdate')->name('navigasi.update');
    Route::delete('v1/navigasi/{id}', 'ServicesController@navigasiDestroy')->name('navigasi.destroy');

    //Version Check
    Route::get('v1/version-check', 'ServicesController@versionCheck')->name('version.check');

    //UPDATE WEBSITE
    Route::get('v1/updates/check', 'ServicesController@updateCheck')->name('updates.updateCheck');
    Route::get('v1/updates/website', 'ServicesController@updateWebsite')->name('updates.website');
});
