<?php $__env->startSection('title', 'Web Update'); ?>
<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
  <h1>
    Web Update
    <small>Halaman untuk update patch website</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
    <li class="active">Website Patch Update</li>
  </ol>
</section>

<!-- Main content -->
<section class="content">
	<!-- Info boxes -->
	<div class="row">
		<div class="col-md-12">
			<div class="box">
				<div class="box-header with-border">
					<h3 class="box-title"><i class="fa fa-list"></i> Update Website</h3>
				</div>
				<div class="box-body">
                    <?php if($updates == TRUE): ?>
                    <div class="callout callout-success alert-update">
                        <h4>Update Available</h4>
                        <p>Pembaharuan website tersedia, klik tombol update dibawah ini untuk memproses update!</p>
                    </div>
                    <?php else: ?>
                        <?php if($changelog != NULL): ?>
                        <div class="callout callout-info alert-update">
                            <h4>Changelog :</h4>
                            <p>Update version : <?php echo e(env('APP_VER', '21.07.1')); ?><br><?=$changelog?></p>
                        </div>
                        <?php endif; ?>
                    <?php endif; ?>
                    <form id="formUpdate" method="GET" action="<?php echo e(route('system.doUpdate')); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <button class="btn btn-lg btn-success" id="doUpdate" <?php if(!file_exists("latest-update.zip")): ?> disabled <?php endif; ?>> Update</button>
                        </div>
                    </form>
				</div>
			</div>
		</div>
	</div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function(){
    $('body').on('click', '#doUpdate', function(e){
        e.preventDefault();
        var form = $('#formUpdate'),
            url = form.attr('action'),
            method = form.attr('method');
        swal({
            title: "Anda Yakin?",
            text: "Anda yakin melakukan update system web?",
            icon: "warning",
            buttons: [
                'Tidak, batalkan!',
                'Ya, lanjutkan!'
            ],
            dangerMode: true,
        }).then(function(isConfirm) {
            $('.preloader').fadeIn();
            clearTimeout(timeout);

            $.ajax({
                url: url,
                method: method,
                dataType: "JSON",
                success: function(response){
                    timeout = setTimeout(loaded, 1000);
                    if(response.code === 200){
                        swal({
                            type: 'success',
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.msg,
                        }).then(function(){
                            window.location.reload();
                        });
                    }else{
                        swal({
                            type: 'error',
                            icon: 'error',
                            title: 'Gagal!',
                            text: response.msg,
                        }).then(function(){
                            window.location.reload();
                        });
                    }
                },
                error: function(xhr){
                    timeout = setTimeout(loaded, 1000);
                    var res = xhr.responseJSON;
                    if($.isEmptyObject(res) == false) {
                        $.each(res.errors, function (key, value) {
                            $('#' + key)
                                .closest('.form-group')
                                .addClass('has-error')
                                .append('<span class="help-block"><strong>' + value + '</strong></span>');
                        });
                    }
                }
            });
        });
    });
});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\websekolah\webapps\resources\views/pages/be/update/form-update.blade.php ENDPATH**/ ?>