<?php $__env->startSection('title', 'Profile Sekolah'); ?>
<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
  <h1>
    Profile
    <small>Setting Profile Sekolah</small>
  </h1>
  <ol class="breadcrumb">
    <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
    <li class="active">Profile</li>
  </ol>
</section>
<!-- Main content -->
<section class="content">
	<!-- Info boxes -->
	<div class="row">
		<?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		<div class="col-md-12">
			<div class="box">
				<div class="box-header with-border">
					<h3 class="box-title"><i class="fa fa-info-circle"></i> Informasi</h3>
					<input type="hidden" name="id_sekolah" id="id_sekolah" value="<?php echo e($row->id); ?>">
				</div>
				<div class="box-body">
					<table class="table table-striped table-bordered table-hover">
						<tbody>
							<tr>
								<td title="Klik untuk edit">
									<span id="def_nama_sekolah"><?php echo e($row->nama_sekolah); ?></span>
									<input type="text" class="form-control" name="nama_sekolah" id="nama_sekolah" value="<?php echo e($row->nama_sekolah); ?>" placeholder="Nama Sekolah" style="display: none;">
								</td>
							</tr>
							<tr>
								<td title="Klik untuk edit">
									<span id="def_deskripsi_sekolah"><?php echo e($row->deskripsi_sekolah); ?></span>
									<input type="text" class="form-control" name="deskripsi_sekolah" id="deskripsi_sekolah" value="<?php echo e($row->deskripsi_sekolah); ?>" placeholder="Deskripsi Sekolah" maxlength="160" style="display: none;">
								</td>
							</tr>
							<tr>
								<td id="logo">
									<a href="#" onclick="document.getElementById('logo-<?php echo e($row->id); ?>').click()" title="Klik untuk ganti logo"><img src="<?php if($row->logo != NULL ): ?><?php echo e(url('assets/files/logo/thumbnail/'.$row->logo.'?time='.time())); ?><?php else: ?><?php echo e(url('assets/frontend/img/no-picture.png?time='.time())); ?><?php endif; ?>" width="10%"></a>
									<form method="post" action="" enctype="multipart/form-data">
									  <input type="hidden" name="_token" id="_token" value="<?php echo e(csrf_token()); ?>">
									  <input type="hidden" name="id" value="<?php echo e($row->id); ?>">
									  <input style="display: none;" type="file" name="logo" id="logo-<?php echo e($row->id); ?>" data-id="<?php echo e($row->id); ?>" class="uploadfoto" accept="image/*">
									</form>
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>
		<div class="col-md-12">
			<div class="box">
				<div class="box-header with-border">
					<h3 class="box-title"><i class="fa fa-bookmark"></i> Media Sosial</h3>
				</div>
				<div class="box-body">
					<table class="table table-striped table-bordered table-hover">
						<tbody>
							<tr>
								<td title="Klik untuk edit">
									<span id="def_facebook"><?php echo e($row->facebook); ?></span>
									<input type="text" class="form-control" name="facebook" id="facebook" value="<?php echo e($row->facebook); ?>" placeholder="Official Facebook" style="display: none;">
								</td>
							</tr>
							<tr>
								<td title="Klik untuk edit">
									<span id="def_twitter"><?php echo e($row->twitter); ?></span>
									<input type="text" class="form-control" name="twitter" id="twitter" value="<?php echo e($row->twitter); ?>" placeholder="Official Twitter" style="display: none;">
								</td>
							</tr>
							<tr>
								<td title="Klik untuk edit">
									<span id="def_instagram"><?php echo e($row->instagram); ?></span>
									<input type="text" class="form-control" name="instagram" id="instagram" value="<?php echo e($row->instagram); ?>" placeholder="Official Instagram" style="display: none;">
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>
		<div class="col-md-12">
			<div class="box">
				<div class="box-header with-border">
					<h3 class="box-title"><i class="fa fa-link"></i> Tautan</h3>
				</div>
				<div class="box-body">
					<table class="table table-striped table-bordered table-hover">
						<thead>
							<tr>
								<th>Nama Tautan</th>
								<th>Alamat Tautan</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td title="Klik untuk edit">
									<span id="def_nama_tautan_1"><?php echo e($row->nama_tautan_1); ?></span>
									<input type="text" class="form-control" name="nama_tautan_1" id="nama_tautan_1" value="<?php echo e($row->nama_tautan_1); ?>" placeholder="Nama Tautan 1" style="display: none;">
								</td>
								<td title="Klik untuk edit">
									<span id="def_tautan_1"><?php echo e($row->tautan_1); ?></span>
									<input type="text" class="form-control" name="tautan_1" id="tautan_1" value="<?php echo e($row->tautan_1); ?>" placeholder="Tautan 1" style="display: none;">
								</td>
							</tr>
							<tr>
								<td title="Klik untuk edit">
									<span id="def_nama_tautan_2"><?php echo e($row->nama_tautan_2); ?></span>
									<input type="text" class="form-control" name="nama_tautan_2" id="nama_tautan_2" value="<?php echo e($row->nama_tautan_2); ?>" placeholder="Nama Tautan 2" style="display: none;">
								</td>
								<td title="Klik untuk edit">
									<span id="def_tautan_2"><?php echo e($row->tautan_2); ?></span>
									<input type="text" class="form-control" name="tautan_2" id="tautan_2" value="<?php echo e($row->tautan_2); ?>" placeholder="Tautan 2" style="display: none;">
								</td>
							</tr>
							<tr>
								<td title="Klik untuk edit">
									<span id="def_nama_tautan_3"><?php echo e($row->nama_tautan_3); ?></span>
									<input type="text" class="form-control" name="nama_tautan_3" id="nama_tautan_3" value="<?php echo e($row->nama_tautan_3); ?>" placeholder="Nama Tautan 3" style="display: none;">
								</td>
								<td title="Klik untuk edit">
									<span id="def_tautan_3"><?php echo e($row->tautan_3); ?></span>
									<input type="text" class="form-control" name="tautan_3" id="tautan_3" value="<?php echo e($row->tautan_3); ?>" placeholder="Tautan 3" style="display: none;">
								</td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>
		<div class="col-md-12">
			<div class="box">
				<div class="box-header with-border">
					<h3 class="box-title"><i class="fa fa-phone"></i> Kontak</h3>
				</div>
				<div class="box-body">
					<div class="table-responsive">
						<table class="table table-bordered">
							<thead>
								<tr>
									<th>Telepon</th>
									<th>Website</th>
									<th>Email</th>
									<th>Alamat</th>
								</tr>
							</thead>
							<tbody>
								<tr>
				                  <td>
				                    <span><?php echo e(Helper::kontak_config('nomor_telepon', Helper::web_config('sekolah_id'))); ?></span>

				                  </td>
				                  <td>
				                    <span><?php echo e(Helper::kontak_config('website', Helper::web_config('sekolah_id'))); ?></span>

				                  </td>
				                  <td>
				                    <span><?php echo e(Helper::kontak_config('email', Helper::web_config('sekolah_id'))); ?></span>

				                  </td>
				                  <td>
				                    <span><?php echo e(Helper::kontak_config('alamat_jalan', Helper::web_config('sekolah_id'))); ?>, RT.<?php echo e(Helper::kontak_config('rt', Helper::web_config('sekolah_id'))); ?>/RW.<?php echo e(Helper::kontak_config('rw', Helper::web_config('sekolah_id'))); ?>. <?php echo e(Helper::kontak_config('nama_dusun', Helper::web_config('sekolah_id'))); ?>, <?php echo e(Helper::kontak_config('desa_kelurahan', Helper::web_config('sekolah_id'))); ?></span>
				        		  </td>
				                </tr>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
	</div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script type="text/javascript">
$(document).ready(function(){
	$('#def_nama_sekolah').on('click', function(){
		document.getElementById("def_nama_sekolah").style.display="none";
		document.getElementById("nama_sekolah").style.display="block";
	});
	$('#def_deskripsi_sekolah').on('click', function(){
		document.getElementById("def_deskripsi_sekolah").style.display="none";
		document.getElementById("deskripsi_sekolah").style.display="block";
	});
	$('#def_facebook').on('click', function(){
		document.getElementById("def_facebook").style.display="none";
		document.getElementById("facebook").style.display="block";
	});
	$('#def_twitter').on('click', function(){
		document.getElementById("def_twitter").style.display="none";
		document.getElementById("twitter").style.display="block";
	});
	$('#def_instagram').on('click', function(){
		document.getElementById("def_instagram").style.display="none";
		document.getElementById("instagram").style.display="block";
	});
	$('#def_nama_tautan_1').on('click', function(){
		document.getElementById("def_nama_tautan_1").style.display="none";
		document.getElementById("nama_tautan_1").style.display="block";
	});
	$('#def_nama_tautan_2').on('click', function(){
		document.getElementById("def_nama_tautan_2").style.display="none";
		document.getElementById("nama_tautan_2").style.display="block";
	});
	$('#def_nama_tautan_3').on('click', function(){
		document.getElementById("def_nama_tautan_3").style.display="none";
		document.getElementById("nama_tautan_3").style.display="block";
	});
	$('#def_tautan_1').on('click', function(){
		document.getElementById("def_tautan_1").style.display="none";
		document.getElementById("tautan_1").style.display="block";
	});
	$('#def_tautan_2').on('click', function(){
		document.getElementById("def_tautan_2").style.display="none";
		document.getElementById("tautan_2").style.display="block";
	});
	$('#def_tautan_3').on('click', function(){
		document.getElementById("def_tautan_3").style.display="none";
		document.getElementById("tautan_3").style.display="block";
	});

	/*Process Update*/
	$('#nama_sekolah').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "<?php echo e(route('profile.update_nama_sekolah')); ?>", // Isi dengan url/path file php yang dituju
			data: {
			_token: "<?php echo e(csrf_token()); ?>",
			id: $('#id_sekolah').val(),
			nama_sekolah: $('#nama_sekolah').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('#deskripsi_sekolah').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "<?php echo e(route('profile.update_deskripsi_sekolah')); ?>", // Isi dengan url/path file php yang dituju
			data: {
			_token: "<?php echo e(csrf_token()); ?>",
			id: $('#id_sekolah').val(),
			deskripsi_sekolah: $('#deskripsi_sekolah').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('body').on('change', '.uploadfoto', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		var id = $(this).attr('data-id');
		var fileSelect = document.getElementById($(this).attr('id'));
		var token = $('#_token').val();
		var files = fileSelect.files[0];
		var formData = new FormData();
		formData.append('logo', files);
		formData.append('id', id);
		formData.append('_token', token);
		$.ajax({
            url: "<?php echo e(route('profile.update_logo')); ?>",
            method: "POST",
            dataType: "JSON",
            data: formData,
            processData: false,
            contentType: false,
            success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    $('#modal').modal('hide');
                    $('#logo').load(location.href + " #logo");
                    swal({
                        type: 'success',
                        icon: 'success',
                        title: 'Berhasil!',
                        text: response.msg,
                    });
                }else{
                    swal({
                        type: 'error',
                        icon: 'error',
                        title: 'Gagal!',
                        text: response.msg,
                    });
                }
            },
            error: function(xhr, status, error){
                timeout = setTimeout(loaded, 1000);
                $('#modal').modal('hide');
                $('#datatables').DataTable().ajax.reload();
                data = JSON.parse(xhr.responseText);
                $.each(data, function(key, item){
                    swal({
                    type: 'error',
                    icon: 'error',
                    title: 'Gagal!',
                    text: 'Gagal upload logo, '+item.logo+'!'
                    });
                });
            }
		});
	});

	$('#facebook').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "<?php echo e(route('profile.update_facebook')); ?>", // Isi dengan url/path file php yang dituju
			data: {
			_token: "<?php echo e(csrf_token()); ?>",
			id: $('#id_sekolah').val(),
			facebook: $('#facebook').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText
                });
			}
		})
	});

	$('#twitter').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "<?php echo e(route('profile.update_twitter')); ?>", // Isi dengan url/path file php yang dituju
			data: {
			_token: "<?php echo e(csrf_token()); ?>",
			id: $('#id_sekolah').val(),
			twitter: $('#twitter').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('#instagram').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "<?php echo e(route('profile.update_instagram')); ?>", // Isi dengan url/path file php yang dituju
			data: {
			_token: "<?php echo e(csrf_token()); ?>",
			id: $('#id_sekolah').val(),
			instagram: $('#instagram').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('#nama_tautan_1').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "<?php echo e(route('profile.update_nama_tautan_1')); ?>", // Isi dengan url/path file php yang dituju
			data: {
			_token: "<?php echo e(csrf_token()); ?>",
			id: $('#id_sekolah').val(),
			nama_tautan_1: $('#nama_tautan_1').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('#nama_tautan_2').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "<?php echo e(route('profile.update_nama_tautan_2')); ?>", // Isi dengan url/path file php yang dituju
			data: {
			_token: "<?php echo e(csrf_token()); ?>",
			id: $('#id_sekolah').val(),
			nama_tautan_2: $('#nama_tautan_2').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('#nama_tautan_3').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "<?php echo e(route('profile.update_nama_tautan_3')); ?>", // Isi dengan url/path file php yang dituju
			data: {
			_token: "<?php echo e(csrf_token()); ?>",
			id: $('#id_sekolah').val(),
			nama_tautan_3: $('#nama_tautan_3').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('#tautan_1').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "<?php echo e(route('profile.update_tautan_1')); ?>", // Isi dengan url/path file php yang dituju
			data: {
			_token: "<?php echo e(csrf_token()); ?>",
			id: $('#id_sekolah').val(),
			tautan_1: $('#tautan_1').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('#tautan_2').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "<?php echo e(route('profile.update_tautan_2')); ?>", // Isi dengan url/path file php yang dituju
			data: {
			_token: "<?php echo e(csrf_token()); ?>",
			id: $('#id_sekolah').val(),
			tautan_2: $('#tautan_2').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

	$('#tautan_3').on('change', function(e){
        e.preventDefault();
        $('.preloader').fadeIn();
        clearTimeout(timeout);

		$.ajax({
			type: "POST", // Method pengiriman data bisa dengan GET atau POST
			url: "<?php echo e(route('profile.update_tautan_3')); ?>", // Isi dengan url/path file php yang dituju
			data: {
			_token: "<?php echo e(csrf_token()); ?>",
			id: $('#id_sekolah').val(),
			tautan_3: $('#tautan_3').val(),
			}, // data yang akan dikirim ke file yang dituju
			dataType: "json",
			success: function(response){
                timeout = setTimeout(loaded, 1000);
                if(response.code === 200){
                    swal({
                        title: 'Berhasil!',
                        icon: 'success',
                        text: response.msg,
                    });
                }else{
                    swal({
                        title: 'Gagal!',
                        icon: 'error',
                        text: response.msg,
                    });
                }
			},
			error: function(xhr){
                timeout = setTimeout(loaded, 1000);
				swal({
                    title: 'Gagal!',
                    icon: 'error',
                    text: xhr.statusText,
                });
			}
		})
	});

});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\websekolah\webapps\resources\views/pages/be/profile-sekolah.blade.php ENDPATH**/ ?>